# Usage

Every lain widget is a table.

A lain widget is generated by a `function`.

The `function` signature, input and output arguments can be found in the [related wiki entry](https://github.com/copycat-killer/lain/wiki/Widgets#index).

Every lain widget contains a `wibox.widget`, which is updated by a timed function. To access the widget, use the field `widget`, while to access the timed function, use the field `update`. Some lain widgets may also have an `icon` field, which is a `wibox.widget.imagebox`, and/or a `timer` field, which is the `gears.timer` on `update`.

Every `function` may take either a table or a list of variables as input.

If the input is a table, you must define a function variable called `settings` in it. There you will be able to define `widget` appearance.

For instance, if `widget` is a textbox, to markup it call `widget:set_markup(...)` within `settings`.

In the scope of `settings` you can use predefined arguments, which are specified in the wiki entries.

Example of a lain widget:

```lua
local cpu = lain.widget.cpu {
    settings = function()
        widget:set_markup("Cpu " .. cpu_now.usage)
    end
}
-- to access the widget: cpu.widget
```

If you want to see some applications, check [awesome-copycats](https://github.com/copycat-killer/awesome-copycats).

# Index

- [alsa](https://github.com/copycat-killer/lain/wiki/alsa)
- [alsabar](https://github.com/copycat-killer/lain/wiki/alsabar)
- [bat](https://github.com/copycat-killer/lain/wiki/bat)
- [calendar](https://github.com/copycat-killer/lain/wiki/calendar)
- [cpu](https://github.com/copycat-killer/lain/wiki/cpu)
- [fs](https://github.com/copycat-killer/lain/wiki/fs)
- [imap](https://github.com/copycat-killer/lain/wiki/imap)
- [mem](https://github.com/copycat-killer/lain/wiki/mem)
- [mpd](https://github.com/copycat-killer/lain/wiki/mpd)
- [net](https://github.com/copycat-killer/lain/wiki/net)
- [pulse](https://github.com/copycat-killer/lain/wiki/pulse)
- [pulsebar](https://github.com/copycat-killer/lain/wiki/pulsebar)
- [sysload](https://github.com/copycat-killer/lain/wiki/sysload)
- [temp](https://github.com/copycat-killer/lain/wiki/temp)
- [weather](https://github.com/copycat-killer/lain/wiki/weather)

## Users contributed

- [kbdlayout](https://github.com/copycat-killer/lain/wiki/kbdlayout)
- [moc](https://github.com/copycat-killer/lain/wiki/moc)
- [redshift](https://github.com/copycat-killer/lain/wiki/redshift)
- [task](https://github.com/copycat-killer/lain/wiki/task)
- [tpbat](https://github.com/copycat-killer/lain/wiki/tpbat)
