local wezterm  = require 'wezterm'
local act = wezterm.action

return {



  -- Clipboard
  -- Copy
  { key = 'c',
    mods = 'SHIFT|CTRL',
    action = act.CopyTo 'ClipboardAndPrimarySelection', },

  -- Paste
  { key = 'v',
    mods = 'SHIFT|CTRL',
    action = act.PasteFrom 'Clipboard', },


  -- Font
  -- Increase
  { key = '+',
    mods = 'CTRL',
    action = act.IncreaseFontSize, },

  -- Decrease
  { key = '-',
    mods = 'CTRL',
    action = act.DecreaseFontSize, },

  -- Copy mode
  { key = 'X',
    mods = 'SHIFT|CTRL',
    action = act.ActivateCopyMode, },

  -- Search
  { key = 'F',
    mods = 'SHIFT|CTRL',
    action = act.Search { CaseInSensitiveString = '' }, },



  -- Panes
  -- Open vertical pane
  { key = '%',
    mods = 'SHIFT|CTRL',
    action = wezterm.action.SplitHorizontal { domain = 'CurrentPaneDomain' }, },

  -- Open horizontal pane
  { key = '"',
    mods = 'SHIFT|CTRL',
    action = wezterm.action.SplitVertical { domain = 'CurrentPaneDomain' }, },

  -- Close pane
  { key = 'q',
    mods = 'CTRL',
    action = wezterm.action.CloseCurrentPane { confirm = true }, },



  -- Resize pane
  -- Resize pane to the left
  { key = 'LeftArrow',
    mods = 'SHIFT|CTRL|ALT',
    action = act.AdjustPaneSize { 'Left', 1 } },
  { key = 'h',
    mods = 'SHIFT|CTRL|ALT',
    action = act.AdjustPaneSize { 'Left', 1 } },

  -- Resize pane to the right
  { key = 'RightArrow',
    mods = 'SHIFT|CTRL|ALT',
    action = act.AdjustPaneSize { 'Right', 1 } },
  { key = 'l',
    mods = 'SHIFT|CTRL|ALT',
    action = act.AdjustPaneSize { 'Right', 1 } },

  -- Resize pane up
  { key = 'UpArrow',
    mods = 'SHIFT|CTRL|ALT',
    action = act.AdjustPaneSize { 'Up', 1 } },
  { key = 'k',
    mods = 'SHIFT|CTRL|ALT',
    action = act.AdjustPaneSize { 'Up', 1 } },

  -- Resize pane down
  { key = 'DownArrow',
    mods = 'SHIFT|CTRL|ALT',
    action = act.AdjustPaneSize { 'Down', 1 } },
  { key = 'j',
    mods = 'SHIFT|CTRL|ALT',
    action = act.AdjustPaneSize { 'Down', 1 } },



  -- Move pane
  -- Move pane to the left
  { key = 'LeftArrow',
    mods = 'SHIFT|CTRL',
    action = act.ActivatePaneDirection 'Left' },
  { key = 'h',
    mods = 'SHIFT|CTRL',
    action = act.ActivatePaneDirection 'Left' },

  -- Move pane to the right
  { key = 'RightArrow',
    mods = 'SHIFT|CTRL',
    action = act.ActivatePaneDirection 'Right' },
  { key = 'l',
    mods = 'SHIFT|CTRL',
    action = act.ActivatePaneDirection 'Right' },

  -- Move pane up
  { key = 'UpArrow',
    mods = 'SHIFT|CTRL',
    action = act.ActivatePaneDirection 'Up' },
  { key = 'k',
    mods = 'SHIFT|CTRL',
    action = act.ActivatePaneDirection 'Up' },

  -- Move pane down
  { key = 'DownArrow',
    mods = 'SHIFT|CTRL',
    action = act.ActivatePaneDirection 'Down' },
  { key = 'j',
    mods = 'SHIFT|CTRL',
    action = act.ActivatePaneDirection 'Down' },



  -- Tabs
  -- New tab
  { key = 'T',
    mods = 'SHIFT|CTRL',
    action = act.SpawnTab 'DefaultDomain', },

  -- Close tab
  { key = 'Q',
    mods = 'SHIFT|CTRL',
    action = wezterm.action.CloseCurrentTab { confirm = true }, },

  -- Move tabs
  -- Move tab to the left
  { key='{',
    mods = 'SHIFT|CTRL',
    action=wezterm.action { ActivateTabRelative=-1 }, },

  -- Move tab to the right
  { key='}',
    mods = 'SHIFT|CTRL',
    action = wezterm.action { ActivateTabRelative=1 }, },



}