# Pull Request

## Description

Please read these instructions and remove unnecessary text.

- Try to include a summary of the changes and which issue is fixed.
- Also include relevant motivation and context (if applicable).
- List any dependencies that are required for this change. (e.g., packages or other PRs)
- Provide a link if there is an issue related to this pull request. e.g., Fixes # (issue)
- Please add Reviewers, Assignees, Labels, Projects, and Milestones to the PR. (if applicable)

## Type of change

Please put an `x` in the boxes that apply:

- [ ] **Bug fix** (non-breaking change which fixes an issue)
- [ ] **New feature** (non-breaking change which adds functionality)
- [ ] **Breaking change** (fix or feature that would cause existing functionality to not work as expected)
- [ ] **Documentation update** (non-breaking change; modified files are limited to the documentations)
- [ ] **Technical debt** (a code change that does not fix a bug or add a feature but makes something clearer for devs)
- [ ] **Other** (provide details below)

## Checklist

Please put an `x` in the boxes that apply:

- [ ] I have read the [CONTRIBUTING](https://github.com/prasanthrangan/hyprdots/blob/main/CONTRIBUTING.md) document.
- [ ] My code follows the code style of this project.
- [ ] My commit message follows the [commit guidelines](https://github.com/prasanthrangan/hyprdots/blob/main/CONTRIBUTING.md#git-commit-messages).
- [ ] My change requires a change to the documentation.
- [ ] I have updated the documentation accordingly.
- [ ] I have added a changelog entry.
- [ ] I have added necessary comments/documentation to my code.
- [ ] I have added tests to cover my changes.
- [ ] I have tested my code locally and it works as expected.
- [ ] All new and existing tests passed.

## Screenshots

(if appropriate)

## Additional context

Add any other context about the problem here.
